import { NextResponse } from "next/server";

export async function POST(req: Request) {
  const { name, email, phonenumber, description, captchaToken } =
    await req.json();

  const secret = process.env.RECAPTCHA_SECRET_KEY;

  const captchaRes = await fetch(
    "https://www.google.com/recaptcha/api/siteverify",
    {
      method: "POST",
      headers: {
        "Content-Type": "application/x-www-form-urlencoded",
      },
      body: `secret=${secret}&response=${captchaToken}`,
    }
  );

  const captchaData = await captchaRes.json();

  if (!captchaData.success) {
    return NextResponse.json(
      { error: "Captcha verification failed" },
      { status: 400 }
    );
  }

  // ✅ Now safe to send email / save DB
  // Call your PHP API here if needed

  return NextResponse.json({ success: true });
}
