import { useEffect, useRef } from "react";
import { gsap } from "@/helpers/gsap";


export default function CustomCursor() {

    useEffect(() => {
    const cursor = document.querySelector(".custom-cursor__cursor") as HTMLElement;
    const cursorInner = document.querySelector(".custom-cursor__cursor-two") as HTMLElement;
    const links = document.querySelectorAll("a");

    if (!cursor || !cursorInner) return;

    // Smooth follow (outer cursor)
    document.addEventListener("mousemove", (e) => {
      gsap.to(cursor, {
        x: e.clientX,
        y: e.clientY,
        duration: 0.2,
        ease: "power2.out",
      });

      gsap.set(cursorInner, {
        x: e.clientX,
        y: e.clientY,
      });
    });

    // Click animation
    document.addEventListener("mousedown", () => {
      cursor.classList.add("click");
      cursorInner.classList.add("custom-cursor__innerhover");
    });

    document.addEventListener("mouseup", () => {
      cursor.classList.remove("click");
      cursorInner.classList.remove("custom-cursor__innerhover");
    });

    // Hover on links
    links.forEach((link) => {
      link.addEventListener("mouseenter", () => {
        cursor.classList.add("custom-cursor__hover");
      });

      link.addEventListener("mouseleave", () => {
        cursor.classList.remove("custom-cursor__hover");
      });
    });

  }, []);


  return (
    <>
      <div className="custom-cursor__cursor"></div>
    <div className="custom-cursor__cursor-two"></div>
    </>
  );
}
