import React from "react";
import { usePathname } from "next/navigation";
import SiteFooterTwoImg from "@/public/images/shapes/site-footer-two-bg-shape.png";
import FooterLogo from "@/public/images/resources/footer-logo.png";

function Footer() {
    return (
        <>
            <div className="site-footer__top">
                <div className="container">
                    <div className="site-footer__top-inner">
                        <div className="footer-widget__title-box">
                            <h2 className="footer-widget__title">Let&apos;s Create<br /> Something Great</h2>
                            <p className="footer-widget__text">We shift you from today’s reality to tomorrow’s potential,
                                ensuring</p>
                        </div>
                        <div className="footer-widget__btn">
                            <a href="contact.html">Let’s Talk<span className="icon-arrow-up-right"></span></a>
                        </div>
                    </div>
                </div>
            </div>
            <footer className="site-footer-two">
                <div className="site-footer-two__bg-shape"
                    style={{ backgroundImage: `url(${SiteFooterTwoImg.src})` }}></div>
                <div className="site-footer-two__top">
                    <div className="container">
                        <div className="row">
                            <div className="col-xl-4 col-lg-6 col-md-6 wow fadeInUp" data-wow-delay="100ms">
                                <div className="footer-widget-two__column footer-widget-two__about">
                                    <div className="footer-widget-two__logo">
                                        <a href="index.html"><img src={'/images/footlogo.svg'} alt="" /></a>
                                    </div>
                                    <div className="footer-widget-two__place">
                                        <div className="footer-widget-two__place-single">
                                            <h4 className="footer-widget-two__place-title">New Work</h4>
                                            <p className="footer-widget-two__place-text">Travel World House, Level<br /> 7, 17
                                                Jones St, NSW,</p>
                                        </div>
                                        <div className="footer-widget-two__place-single">
                                            <h4 className="footer-widget-two__place-title">London</h4>
                                            <p className="footer-widget-two__place-text">Travel World House, Level<br /> 7, 17
                                                Jones St, NSW,</p>
                                        </div>
                                    </div>
                                    <div className="site-footer-two__social">
                                        <a href="#"><i className="icon-facebook"></i></a>
                                        <a href="#"><i className="icon-twitter"></i></a>
                                        <a href="#"><i className="icon-instagram"></i></a>
                                        <a href="#"><i className="icon-beeeee"></i></a>
                                    </div>
                                </div>
                            </div>
                            <div className="col-xl-2 col-lg-6 col-md-6 wow fadeInUp" data-wow-delay="200ms">
                                <div className="footer-widget-two__column footer-widget-two__link">
                                    <div className="footer-widget-two__title-box">
                                        <h3 className="footer-widget-two__title">Services</h3>
                                    </div>
                                    <ul className="footer-widget-two__link-list list-unstyled">
                                        <li><a href="services.html">UI/UX Design</a></li>
                                        <li><a href="services.html">Web design</a></li>
                                        <li><a href="services.html">Branding</a></li>
                                        <li><a href="services.html">Webflow</a></li>
                                        <li><a href="services.html">Development</a></li>
                                    </ul>
                                </div>
                            </div>
                            <div className="col-xl-2 col-lg-6 col-md-6 wow fadeInUp" data-wow-delay="200ms">
                                <div className="footer-widget-two__column footer-widget-two__company">
                                    <div className="footer-widget-two__title-box">
                                        <h3 className="footer-widget-two__title">Company</h3>
                                    </div>
                                    <ul className="footer-widget-two__link-list list-unstyled">
                                        <li><a href="index.html">Home</a></li>
                                        <li><a href="about.html">Agency</a></li>
                                        <li><a href="services.html">Achievement</a></li>
                                        <li><a href="about.html">Career</a></li>
                                        <li><a href="contact.html">Contact Us</a></li>
                                    </ul>
                                </div>
                            </div>
                            <div className="col-xl-4 col-lg-6 col-md-6 wow fadeInUp" data-wow-delay="300ms">
                                <div className="footer-widget-two__column footer-widget-two__newsletter">
                                    <div className="footer-widget-two__title-box">
                                        <h3 className="footer-widget-two__title">Newsletter</h3>
                                    </div>
                                    <p className="footer-widget-two__newsletter-text">Feel free to reach out if you want to
                                        collaborate with us, or simply have a chat.</p>
                                    <form className="footer-widget-two__newsletter-form">
                                        <div className="footer-widget-two__newsletter-form-input-box">
                                            <div className="footer-widget-two__newsletter-icon">
                                                <span className="far fa-envelope"></span>
                                            </div>
                                            <input type="email" placeholder="Enter Your Email " name="email" />
                                            <button type="submit" className="footer-widget-two__newsletter-btn"><span
                                                className="icon-paper-plane"></span></button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div className="site-footer-two__bottom">
                    <div className="container">
                        <div className="row">
                            <div className="col-xl-12">
                                <div className="site-footer-two__bottom-inner">
                                    <p className="site-footer-two__bottom-text">Copyright © 2025 <a href="#">Nexin</a>. All
                                        Rights Reserved.
                                    </p>
                                    <ul className="list-unstyled site-footer-two__bottom-menu">
                                        <li><a href="about.html">Privacy</a></li>
                                        <li><span></span></li>
                                        <li><a href="about.html">Terms & Condition</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </footer>
        </>
    )
};

export default Footer;
