import Image from "react-bootstrap/Image";
import logo from "@/public/images/resources/logo-1.png";
import logo3 from "@/public/images/resources/logo-3.png";
import HomeShowcaseOne from "@/public/images/home-showcase/home-showcase-1-1.jpg";
import HomeShowcaseTwo from "@/public/images/home-showcase/home-showcase-1-2.jpg";
import HomeShowcaseThree from "@/public/images/home-showcase/home-showcase-1-3.jpg";
import { useEffect } from "react";
import { usePathname } from "next/navigation";
import { Container } from "react-bootstrap";

function Header() {
  const pathname = usePathname();

  useEffect(() => {
    function dynamicCurrentMenuClass(selector: HTMLElement) {
      const fileName = window.location.pathname.split("/").pop() || "";

      // Remove existing 'current' classes
      selector.querySelectorAll("li").forEach((li) => {
        li.classList.remove("current");
      });

      // Loop through all li elements
      selector.querySelectorAll("li").forEach((li) => {
        const anchor = li.querySelector("a");

        if (anchor && anchor.getAttribute("href") === fileName) {
          li.classList.add("current");

          // Add current to parent dropdown if exists
          const parentDropdown = li.closest("li.dropdown");
          if (parentDropdown) {
            parentDropdown.classList.add("current");
          }
        }
      });

      // If no current found → set first li active
      if (!selector.querySelector("li.current")) {
        const firstLi = selector.querySelector(":scope > li");
        if (firstLi) firstLi.classList.add("current");
      }
    }

    const mainMenuList = document.querySelector(
      ".main-menu__list",
    ) as HTMLElement | null;

    if (mainMenuList) {
      dynamicCurrentMenuClass(mainMenuList);
    }

    const mobileNavContainer = document.querySelector(
      ".mobile-nav__container",
    ) as HTMLElement | null;

    if (mainMenuList && mobileNavContainer) {
      mobileNavContainer.innerHTML = mainMenuList.outerHTML;
    }

    const stickyHeaderContent = document.querySelector(
      ".sticky-header__content",
    ) as HTMLElement | null;

    const mainMenu = document.querySelector(".main-menu") as HTMLElement | null;

    if (stickyHeaderContent && mainMenu) {
      stickyHeaderContent.innerHTML = mainMenu.innerHTML;
    }

    const mobileMenuList = document.querySelector(
      ".mobile-nav__container .main-menu__list",
    );

    if (mobileMenuList) {
      const dropdownAnchors = mobileMenuList.querySelectorAll(".dropdown > a");

      dropdownAnchors.forEach((anchor) => {
        const toggleBtn = document.createElement("button");
        toggleBtn.setAttribute("aria-label", "dropdown toggler");
        toggleBtn.innerHTML = "<i className='fa fa-angle-down'></i>";

        anchor.appendChild(toggleBtn);

        toggleBtn.addEventListener("click", (e) => {
          e.preventDefault();

          toggleBtn.classList.toggle("expanded");
          anchor.classList.toggle("expanded");

          const parentLi = anchor.parentElement;
          const subMenu = parentLi?.querySelector("ul");

          if (subMenu) {
            if (subMenu instanceof HTMLElement) {
              subMenu.style.display =
                subMenu.style.display === "block" ? "none" : "block";
            }
          }
        });
      });
    }

    const togglers = document.querySelectorAll(".mobile-nav__toggler");

    togglers.forEach((toggler) => {
      toggler.addEventListener("click", (e) => {
        e.preventDefault();

        const wrapper = document.querySelector(".mobile-nav__wrapper");
        wrapper?.classList.toggle("expanded");
        document.body.classList.toggle("locked");
      });
    });
  }, []);

  useEffect(() => {
    document.body.classList.remove("page-home", "page-about");

    if (pathname === "/") {
      document.body.classList.add("page-home");
    } else {
      document.body.classList.add("page-about");
    }
  }, [pathname]);

  if (pathname == "/") {
    return (
      <>
        <div className="main-header">
          <nav className="main-menu">
            <div className="main-menu__wrapper">
              <Container>
                <div className="main-menu__wrapper-inner">
                  <div className="main-menu__left">
                    <div className="main-menu__logo">
                      <a href="/">
                        <Image src={'/images/logo.svg'} alt="" />
                      </a>
                    </div>
                  </div>
                  <div className="main-menu__main-menu-box">
                    <a href="#" className="mobile-nav__toggler">
                      Menu
                      <i className="fa fa-bars" />
                    </a>
                    <ul className="main-menu__list">
                      <li className="">
                        <a href="/">Home </a>
                      </li>
                    
                      <li className="dropdown">
                        <a href="/services">services</a>
                        <ul className="shadow-box">
                          <li>
                            <a href="/services">Services</a>
                          </li>
                          <li>
                            <a href="services-carousel.html">Services Carousel</a>
                          </li>
                          <li>
                            <a href="service-details.html">Service Details</a>
                          </li>
                        </ul>
                      </li>
                      <li className="dropdown">
                        <a href="/portfolio">Portfolio</a>
                        <ul className="shadow-box">
                          <li>
                            <a href="/portfolio">Portfolio</a>
                          </li>
                          <li>
                            <a href="portfolio-carousel.html">
                              Portfolio Corousel
                            </a>
                          </li>
                          <li>
                            <a href="portfolio-details.html">Portfolio Details</a>
                          </li>
                        </ul>
                      </li>
                      <li className="dropdown">
                        <a href="#">Insights</a>
                        <ul className="shadow-box">
                          <li>
                            <a href="blog.html">Blog</a>
                          </li>
                          <li>
                            <a href="blog-carousel.html">Blog Carousel</a>
                          </li>
                          <li>
                            <a href="blog-list.html">Blog List</a>
                          </li>
                          <li>
                            <a href="blog-details.html">Blog Details</a>
                          </li>
                        </ul>
                      </li>
                        <li>
                        <a href="/about">About</a>
                      </li>
                      <li>
                        <a href="contact.html">Contact</a>
                      </li>
                    </ul>
                  </div>
                  <div className="main-menu__right">
                    <div className="main-menu__btn-box">
                      <a href="contact.html" className="thm-btn">
                        Get A Quote
                        <span className="icon-arrow-up-right"></span>
                      </a>
                    </div>
                  </div>
                </div>
              </Container>
            </div>
          </nav>
        </div>

        <div className="stricky-header stricked-menu main-menu">
          <div className="sticky-header__content"></div>
        </div>

        <div className="mobile-nav__wrapper">
          <div className="mobile-nav__overlay mobile-nav__toggler"></div>

          <div className="mobile-nav__content">
            <span className="mobile-nav__close mobile-nav__toggler">
              Close<i className="fa fa-times"></i>
            </span>

            <div className="logo-box">
              <a href="index.html" aria-label="logo image">
                <img
                  src="assets/images/resources/logo-4.png"
                  width="150"
                  alt=""
                />
              </a>
            </div>

            <div className="mobile-nav__container"></div>

            <ul className="mobile-nav__contact list-unstyled">
              <li>
                <i className="fa fa-envelope"></i>
                <a href="mailto:needhelp@packageName__.com">
                  needhelp@Nexin.com
                </a>
              </li>
              <li>
                <i className="fas fa-phone"></i>
                <a href="tel:666-888-0000">666 888 0000</a>
              </li>
            </ul>
            <div className="mobile-nav__top">
              <div className="mobile-nav__social">
                <a href="#" className="fab fa-twitter"></a>
                <a href="#" className="fab fa-facebook-square"></a>
                <a href="#" className="fab fa-pinterest-p"></a>
                <a href="#" className="fab fa-instagram"></a>
              </div>
            </div>
          </div>
        </div>
      </>
    );
  } else {
    return (
      <>
        <div className="main-header-four">
          <nav className="main-menu main-menu-four">
            <div className="main-menu-four__wrapper">
              <div className="main-menu-four__wrapper-inner">
                <div className="main-menu-four__left">
                  <div className="main-menu-four__logo">
                    <a href="/">
                      <img src={'/images/footlogo.svg'} alt="" />
                    </a>
                  </div>
                </div>
                <div className="main-menu-four__main-menu-box">
                  <a href="#" className="mobile-nav__toggler">
                    Menu<i className="fa fa-bars"></i>
                  </a>
                  <ul className="main-menu__list">
                    <li className="">
                      <a href="/">Home </a>
                      
                    </li>
                    <li>
                      <a href="/about">About</a>
                    </li>
                  
                    <li className="dropdown">
                      <a href="/services">services</a>
                      <ul className="shadow-box">
                        <li>
                          <a href="/services">Services</a>
                        </li>
                        <li>
                          <a href="services-carousel.html">Services Carousel</a>
                        </li>
                        <li>
                          <a href="service-details.html">Service Details</a>
                        </li>
                      </ul>
                    </li>
                    <li className="dropdown">
                      <a href="/portfolio">Portfolio</a>
                      <ul className="shadow-box">
                        <li>
                          <a href="/portfolio">Portfolio</a>
                        </li>
                        <li>
                          <a href="portfolio-carousel.html">
                            Portfolio Corousel
                          </a>
                        </li>
                        <li>
                          <a href="portfolio-details.html">Portfolio Details</a>
                        </li>
                      </ul>
                    </li>
                    <li className="dropdown">
                      <a href="#">Insights</a>
                      <ul className="shadow-box">
                        <li>
                          <a href="blog.html">Blog</a>
                        </li>
                        <li>
                          <a href="blog-carousel.html">Blog Carousel</a>
                        </li>
                        <li>
                          <a href="blog-list.html">Blog List</a>
                        </li>
                        <li>
                          <a href="blog-details.html">Blog Details</a>
                        </li>
                      </ul>
                    </li>
                    <li>
                      <a href="contact.html">Contact</a>
                    </li>
                  </ul>
                </div>
                <div className="main-menu__right">
                
                  <div className="main-menu-four__btn-box">
                    <a href="contact.html" className="thm-btn">
                      Get A Quote
                      <span className="icon-arrow-up-right"></span>
                    </a>
                  </div>
                </div>
              </div>
            </div>
          </nav>
        </div>

        <div className="stricky-header stricked-menu main-menu main-menu-four">
          <div className="sticky-header__content"></div>
        </div>

        <div className="mobile-nav__wrapper">
          <div className="mobile-nav__overlay mobile-nav__toggler"></div>

          <div className="mobile-nav__content">
            <span className="mobile-nav__close mobile-nav__toggler">
              Close<i className="fa fa-times"></i>
            </span>

            <div className="logo-box">
              <a href="index.html" aria-label="logo image">
                <img
                  src="assets/images/resources/logo-4.png"
                  width="150"
                  alt=""
                />
              </a>
            </div>

            <div className="mobile-nav__container"></div>

            <ul className="mobile-nav__contact list-unstyled">
              <li>
                <i className="fa fa-envelope"></i>
                <a href="mailto:needhelp@packageName__.com">
                  needhelp@Nexin.com
                </a>
              </li>
              <li>
                <i className="fas fa-phone"></i>
                <a href="tel:666-888-0000">666 888 0000</a>
              </li>
            </ul>
            <div className="mobile-nav__top">
              <div className="mobile-nav__social">
                <a href="#" className="fab fa-twitter"></a>
                <a href="#" className="fab fa-facebook-square"></a>
                <a href="#" className="fab fa-pinterest-p"></a>
                <a href="#" className="fab fa-instagram"></a>
              </div>
            </div>
          </div>
        </div>
      </>
    );
  }
}

export default Header;
