"use client";

import { useEffect, useRef } from "react";
import gsap from "gsap";

export default function ShadeOnScroll() {
  const shadeRef = useRef<HTMLDivElement>(null);
  let scrollTimeout: NodeJS.Timeout;

  useEffect(() => {
    const handleScroll = () => {
      if (shadeRef.current) {
        // scroll hote hi dikhado
        gsap.to(shadeRef.current, {
          opacity: 1,
          duration: 0.3,
          ease: "power2.out",
        });
      }

      // scroll rukne par hide karna
      clearTimeout(scrollTimeout);
      scrollTimeout = setTimeout(() => {
        if (shadeRef.current) {
          gsap.to(shadeRef.current, {
            opacity: 0,
            duration: 0.5,
            ease: "power2.out",
          });
        }
      }, 200);
    };

    window.addEventListener("scroll", handleScroll);
    return () => {
      window.removeEventListener("scroll", handleScroll);
      clearTimeout(scrollTimeout);
    };
  }, []);

  return (
    <div
      ref={shadeRef}
      className="shade"
      // style={{
      //   background: "rgba(0,0,0,0.2)", // halka shade
      // }}
    />
  );
}
