import Link from "next/link";
import React, { useEffect, useState } from "react";
import { Modal } from "react-bootstrap";
import Image from "react-bootstrap/Image";

function Technology() {
  useEffect(() => {
    const cards = document.querySelectorAll(".technology-item");

    cards.forEach((card) => {
      card.addEventListener("mouseenter", () => {
        (card as HTMLElement).style.transform =
          "perspective(1500px) rotateX(-45deg)";
        (card as HTMLElement).style.opacity = "1"; // hovered card full visible

        cards.forEach((other) => {
          if (other !== card) {
            (other as HTMLElement).style.opacity = "0.25"; // others dim
          }
        });
      });

      card.addEventListener("mouseleave", () => {
        (card as HTMLElement).style.transform =
          "perspective(1500px) rotateX(0deg)";

        // reset all cards
        cards.forEach((c) => {
          (c as HTMLElement).style.opacity = "1";
        });
      });

      // transition apply once
      (card as HTMLElement).style.transition =
        "transform 0.6s cubic-bezier(0.25, 1, 0.22, 1.3), opacity 0.4s ease";
    });

    return () => {
      cards.forEach((card) => {
        card.replaceWith(card.cloneNode(true));
      });
    };
  }, []);

  return (
    <>
      <div className="technology-wrapper">
        <div className="technology-main-item">
          <div className="technology-main-inner">
            <div className="technology-item">
              <div className="technology-rotate-wrap">
                <div className="technology-rotate-img">
                   <video muted loop autoPlay playsInline className="rotate-img">
                    <source
                      src="/images/Ui_Ux_Design_ivx3v4.webm"
                      type="video/webm"
                    />
                  </video>
                  {/* <Image src="/images/card.png" className="rotate-img" alt="" /> */}
                </div>
              </div>
              <div className="content">
                <div className="content-inner">
                  <h6 className="subheading">UI/UX Design</h6>
                  <h4 className="title">Beyond Pretty Screens</h4>
                  <p className="para">
                    Good design isn’t just about “looking modern.”It’s about
                    making every click feel natural.I design Figma prototypes
                    and systems that reduce confusion, speed up dev, and keep
                    users hooked
                  </p>
                </div>
                <Image src="/images/ui.svg" className="technology-img" alt="" />
              </div>
            </div>
          </div>
        </div>
        <div className="technology-main-item">
          <div className="technology-main-inner">
            <div className="technology-item">
              <div className="technology-rotate-wrap">
                <div className="technology-rotate-img">
                    <video muted loop autoPlay playsInline className="rotate-img">
                    <source
                      src="/images/Web_Develpment_viid1u.webm"
                      type="video/webm"
                    />
                  </video>
                  {/* <Image src="/images/card1.png" className="rotate-img" alt="" /> */}
                </div>
              </div>
              <div className="content">
                <div className="content-inner">
                  <h6 className="subheading">Web Development</h6>
                  <h4 className="title">Built to Perform</h4>
                  <p className="para">
                   Templates are easy. But they break when you actually need them to work. I build on WordPress, Webflow, or custom code — clean, scalable, SEO-ready.
                  </p>
                </div>
                <Image src="/images/website-builder.svg" className="technology-img" alt="" />
              </div>
            </div>
          </div>
        </div>
        <div className="technology-main-item">
          <div className="technology-main-inner">
            <div className="technology-item">
              <div className="technology-rotate-wrap">
                <div className="technology-rotate-img">
                    <video muted loop autoPlay playsInline className="rotate-img">
                    <source
                      src="/images/E_commerce_tk8esd.webm"
                      type="video/webm"
                    />
                  </video>
                  {/* <Image src="/images/card2.png" className="rotate-img" alt="" /> */}
                </div>
              </div>
              <div className="content">
                <div className="content-inner">
                  <h6 className="subheading">E-Commerce</h6>
                  <h4 className="title">From Browsers to Buyers</h4>
                  <p className="para">
                   Your product pages aren’t product pages. They’re salespeople.On Shopify, Woo, or BigCommerce, I build stores that tell a story and guide customers to checkout without friction.
                  </p>
                </div>
                <Image src="/images/market.svg" className="technology-img" alt="" />
              </div>
            </div>
          </div>
        </div>
        <div className="technology-main-item">
          <div className="technology-main-inner">
            <div className="technology-item">
              <div className="technology-rotate-wrap">
                <div className="technology-rotate-img">
                    <video muted loop autoPlay playsInline className="rotate-img">
                    <source
                      src="/images/optimization_yjgu2v.webm"
                      type="video/webm"
                    />
                  </video>
                  {/* <Image src="/images/card3.png" className="rotate-img" alt="" /> */}
                </div>
              </div>
              <div className="content">
                <div className="content-inner">
                  <h6 className="subheading">Optimization</h6>
                  <h4 className="title">Because Launch Isn’t the Finish Line</h4>
                  <p className="para">
                  A site can be live and still leave money on the table.Through CRO, SEO, and speed optimization, I fine-tune your site until it works harder than you imagined.
                  </p>
                </div>
                <Image src="/images/optimization.svg" className="technology-img" alt="" />
              </div>
            </div>
          </div>
        </div>
       
      </div>
    </>
  );
}

export default Technology;
