"use client";
import Head from "next/head";
import React, { useEffect, useRef, useState } from "react";
import AOS from "aos";
import "aos/dist/aos.css";
import CircleType from "circletype";
import { gsap } from "@/helpers/gsap";
import { ScrollTrigger } from "gsap/ScrollTrigger";
import AboutSlider from "../components/AboutSlider";
import TestimonialSection from "../components/TestimonialSection";
import FaqsSection from "../components/FaqsSection";
import Image from "react-bootstrap/Image";
import PortfolioSlider from "@/components/PortfolioSlider";

gsap.registerPlugin(ScrollTrigger);
export default function Home() {
  useEffect(() => {
    if (document.querySelector("[data-aos]")) {
      AOS.init({
        duration: 1200,
        easing: "ease",
        mirror: true,
        once: false,
      });

      AOS.refresh();
    }
  }, []);

  const curvedTextRef = useRef<HTMLDivElement>(null);
  useEffect(() => {
    if (curvedTextRef.current) {
      // Initialize CircleType
      new CircleType(curvedTextRef.current)
        .radius(70) // same as your jQuery example
        .dir(1); // clockwise
    }
  }, []);

  const countersRef = useRef<NodeListOf<HTMLHeadingElement> | null>(null);

  useEffect(() => {
    // Select all counters
    countersRef.current = document.querySelectorAll(".count-text");

    if (!countersRef.current) return;

    countersRef.current.forEach((counter) => {
      const end = parseInt(counter.getAttribute("data-stop") || "0", 10);
      const durationMS = parseInt(
        counter.getAttribute("data-speed") || "1500",
        10,
      );
      const duration = durationMS / 1000; // convert ms to seconds

      gsap.fromTo(
        counter,
        { innerText: 0 },
        {
          innerText: end,
          duration: duration,
          ease: "linear",
          snap: { innerText: 1 },
          scrollTrigger: {
            trigger: counter,
            start: "top 80%", // start when element enters viewport
            toggleActions: "play none none none",
          },
          onUpdate: () => {
            counter.innerText = Math.floor(
              Number(counter.innerText),
            ).toString();
          },
        },
      );
    });
  }, []);

  useEffect(() => {
    const videoLinks = document.querySelectorAll(".video-popup");

    const handleClick = (e: Event) => {
      e.preventDefault();

      const target = e.currentTarget as HTMLAnchorElement;
      const url = target.getAttribute("href");
      if (!url) return;

      // Extract YouTube ID
      const videoId = url.split("v=")[1]?.split("&")[0];
      if (!videoId) return;

      const embedUrl = `https://www.youtube.com/embed/${videoId}?autoplay=1`;

      // Create overlay
      const overlay = document.createElement("div");
      overlay.className = "mfp-bg mfp-fade";
      overlay.style.position = "fixed";
      overlay.style.inset = "0";
      overlay.style.background = "rgba(0,0,0,0.8)";
      overlay.style.zIndex = "9999";
      overlay.style.display = "flex";
      overlay.style.alignItems = "center";
      overlay.style.justifyContent = "center";

      // Create popup container
      const popup = document.createElement("div");
      popup.className = "mfp-wrap mfp-fade";
      popup.style.position = "relative";
      popup.style.width = "800px";
      popup.style.maxWidth = "90%";

      popup.innerHTML = `
        <div style="position:relative;">
          <button style="
            position:absolute;
            top:-10px;
            right:-10px;
            background:#fff;
            border:none;
            width:30px;
            height:30px;
            border-radius:50%;
            cursor:pointer;
            font-size:18px;">×</button>
          <iframe 
            width="100%" 
            height="450" 
            src="${embedUrl}" 
            frameborder="0" 
            allow="autoplay; encrypted-media" 
            allowfullscreen>
          </iframe>
        </div>
      `;

      overlay.appendChild(popup);
      document.body.appendChild(overlay);
      document.body.style.overflow = "hidden";

      // Close logic
      const closePopup = () => {
        document.body.removeChild(overlay);
        document.body.style.overflow = "";
      };

      overlay.addEventListener("click", closePopup);
      popup.addEventListener("click", (ev) => ev.stopPropagation());
      popup.querySelector("button")?.addEventListener("click", closePopup);
    };

    videoLinks.forEach((link) => link.addEventListener("click", handleClick));

    return () => {
      videoLinks.forEach((link) =>
        link.removeEventListener("click", handleClick),
      );
    };
  }, []);

  return (
    <>
      <Head>
        <title>Home | Nexin</title>
        <meta name="description" content="" />
      </Head>

      <section className="banner-one">
        <div
          className="banner-one__one-shape-bg"
          style={{
            backgroundImage: `url(${"/images/shapes/banner-one-shape-bg.png"})`,
          }}
        ></div>
        <div
          className="banner-one__shape-one"
          style={{
            backgroundImage: `url(${"/images/shapes/banner-one-shape-1.png"})`,
          }}
        ></div>
        <div className="banner-one__shape-two"></div>
        <div className="container">
          <div className="banner-one__inner">
            <div className="banner-one__sub-title-box">
              <p>
                Great design services <br /> without the pretentiousness.!
              </p>
            </div>
            <div
              className="banner-one__content-one"
              data-aos="fade-right"
              data-aos-duration="1000"
              data-aos-delay="0"
            >
              <h2 className="banner-one__big-title-one">Digital</h2>
            </div>
            <div
              className="banner-one__content-two"
              data-aos="fade-left"
              data-aos-duration="1000"
              data-aos-delay="500"
            >
              <ul className="banner-one__content-two-list">
                <li>
                  <div className="banner-one__content-two-single">
                    <h3>
                      WEB <br /> DESIGN
                    </h3>
                  </div>
                </li>
                <li>
                  <div className="banner-one__content-two-single-two">
                    <Image
                      src={"/images/icon/banner-one-icon-man.png"}
                      alt=""
                    />
                  </div>
                </li>
              </ul>
              <h2 className="banner-one__big-title-two">Solution</h2>
            </div>
            <div className="banner-one__details-box">
              <div className="banner-one__text-box-one">
                <p>
                  We believe that the surest measure of success is when our
                  partners with us more than half It's more than just the
                  visuals. We're here to support your growth.
                </p>
                <a href="#">
                  View all Services<span className="icon-arrow-up-right"></span>
                </a>
              </div>
              <div className="banner-one__review-box">
                <ul className="banner-one__review-list">
                  <li>
                    <div className="banner-one__review-img">
                      <Image
                        src={"/images/resources/banner-one-review-img-1-1.jpg"}
                        alt=""
                      />
                    </div>
                  </li>
                  <li>
                    <div className="banner-one__review-img">
                      <Image
                        src={"/images/resources/banner-one-review-img-1-2.jpg"}
                        alt=""
                      />
                    </div>
                  </li>
                  <li>
                    <div className="banner-one__review-img">
                      <Image
                        src={"/images/resources/banner-one-review-img-1-3.jpg"}
                        alt=""
                      />
                    </div>
                  </li>
                  <li>
                    <div className="banner-one__review-count-box">
                      <h3 className="odometer" data-count="15">
                        00
                      </h3>
                      <span>K+</span>
                    </div>
                  </li>
                </ul>
                <div className="banner-one__review-text-box">
                  <div className="banner-one__review-text">
                    <p>Excellent</p>
                    <div className="banner-one__review-text-count-box">
                      <h3 className="odometer" data-count="4000">
                        00
                      </h3>
                      <span>+</span>
                    </div>
                    <p>Reviews</p>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>

      <section className="explore-one">
        <div
          className="explore-one__bg"
          style={{
            backgroundImage: `url(${"/images/backgrounds/explore-one-bg.jpg"})`,
          }}
        >
          <div className="explore-one__rounded-text">
            <a
              href="https://www.youtube.com/watch?v=Get7rqXYrbQ"
              className="explore-one__curved-circle-box video-popup"
            >
              <div className="curved-circle" ref={curvedTextRef}>
                <span className="curved-circle--item">
                  . Explore More . Explore More
                </span>
              </div>
              <div className="explore-one__icon">
                <span className="icon-arrow-up-right"></span>
              </div>
            </a>
          </div>
        </div>
      </section>

      <section className="about-one">
        <div className="about-one__shape-1">
          <Image src={"/images/shapes/about-one-shape-1.png"} alt="" />
        </div>
        <div className="container">
          <h2 className="about-one__title">
            We collaborate with a few disability service <br />
            providers to create inclusive goods that
            <br /> meet their requirements.
          </h2>
          <div className="row">
            <div className="col-xl-3">
              <div className="about-one__experience-box">
                <div className="about-one__experience-count">
                  <h3 className="odometer" data-count="25">
                    00
                  </h3>
                  <span>+</span>
                </div>
                <p className="about-one__experience-count-text">
                  Years Of Experience
                </p>
              </div>
            </div>
            <div className="col-xl-9">
              <div className="about-one__single-list">
                <div className="row">
                  <div className="col-xl-6 col-lg-6">
                    <div className="about-one__single">
                      <p className="about-one__text">
                        Established in 1995, NEXIN has been a leading force
                        <br />
                        in the digital landscape for over two decades.
                        <br /> We're a passionate team of designers,{" "}
                      </p>
                      <div className="about-one__btn">
                        <a href="about.html">
                          More About Us
                          <span className="icon-arrow-up-right"></span>
                        </a>
                      </div>
                    </div>
                  </div>
                  <div className="col-xl-6 col-lg-6">
                    <div className="about-one__single about-one__single-2">
                      <p className="about-one__text">
                        Established in 1995, NEXIN has been a leading force
                        <br />
                        in the digital landscape for over two decades.
                        <br /> We're a passionate team of designers,{" "}
                      </p>
                      <div className="about-one__btn">
                        <a href="about.html">
                          More About Us
                          <span className="icon-arrow-up-right"></span>
                        </a>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div className="about-one__bottom">
            <AboutSlider />
          </div>
        </div>
      </section>

      <section className="service-one">
        <div className="service-one__shape-1 rotate-me">
          <Image src={"/images/shapes/services-one-shape-1.png"} alt="" />
        </div>
        <div className="service-one__shape-2 float-bob-y">
          <Image src={"/images/shapes/services-one-shape-2.png"} alt="" />
        </div>
        <div className="container">
          <div className="service-one__top">
            <div className="section-title text-left sec-title-animation animation-style2">
              <div className="section-title__tagline-box">
                <div className="section-title__tagline-shape"></div>
                <span className="section-title__tagline">SERVICES</span>
              </div>
              <h2 className="section-title__title title-animation">
                Empowering Brands Through <br />
                Strategic Digital Services
              </h2>
            </div>
            <p className="service-one__top-text">
              Established in 1995, NEXIN has been a leading force
              <br /> in the digital landscape for over two decades. We're
              <br /> a passionate team of designers,{" "}
            </p>
          </div>
          <div className="service-one__bottom">
            <div className="row">
              <div
                className="col-xl-4 col-lg-4 wow fadeInLeft"
                data-wow-delay="100ms"
              >
                <div className="service-one__single">
                  <div className="service-one__single-inner-shape-1"></div>
                  <div className="service-one__arrow">
                    <a href="service-details.html">
                      <span className="icon-arrow-down"></span>
                    </a>
                  </div>
                  <div className="service-one__single-inner">
                    <div className="service-one__sub-title-box">
                      <div className="service-one__sub-title-shape-1"></div>
                      <span className="service-one__sub-title">
                        Visual Branding
                      </span>
                    </div>
                    <h3 className="service-one__title">
                      <a href="service-details.html">
                        Web Design and Development
                      </a>
                    </h3>
                    <div className="service-one__icon">
                      <span className="icon-agency"></span>
                    </div>
                    <p className="service-one__text">
                      Established in 1995, NEXIN has been leading force in the
                      digital landscape for over two decades. We're a
                      passionate{" "}
                    </p>
                  </div>
                </div>
              </div>

              <div
                className="col-xl-4 col-lg-4 wow fadeInUp"
                data-wow-delay="200ms"
              >
                <div className="service-one__single">
                  <div className="service-one__single-inner-shape-1"></div>
                  <div className="service-one__arrow">
                    <a href="service-details.html">
                      <span className="icon-arrow-down"></span>
                    </a>
                  </div>
                  <div className="service-one__single-inner">
                    <div className="service-one__sub-title-box">
                      <div className="service-one__sub-title-shape-1"></div>
                      <span className="service-one__sub-title">
                        Brand Strategy
                      </span>
                    </div>
                    <h3 className="service-one__title">
                      <a href="service-details.html">
                        Branding and Creative Services
                      </a>
                    </h3>
                    <div className="service-one__icon">
                      <span className="icon-branding"></span>
                    </div>
                    <p className="service-one__text">
                      Established in 1995, NEXIN has been leading force in the
                      digital landscape for over two decades. We're a
                      passionate{" "}
                    </p>
                  </div>
                </div>
              </div>

              <div
                className="col-xl-4 col-lg-4 wow fadeInRight"
                data-wow-delay="300ms"
              >
                <div className="service-one__single">
                  <div className="service-one__single-inner-shape-1"></div>
                  <div className="service-one__arrow">
                    <a href="service-details.html">
                      <span className="icon-arrow-down"></span>
                    </a>
                  </div>
                  <div className="service-one__single-inner">
                    <div className="service-one__sub-title-box">
                      <div className="service-one__sub-title-shape-1"></div>
                      <span className="service-one__sub-title">
                        Identity Build
                      </span>
                    </div>
                    <h3 className="service-one__title">
                      <a href="service-details.html">
                        Creative Digital
                        <br /> Agency
                      </a>
                    </h3>
                    <div className="service-one__icon">
                      <span className="icon-creative"></span>
                    </div>
                    <p className="service-one__text">
                      Established in 1995, NEXIN has been leading force in the
                      digital landscape for over two decades. We're a
                      passionate{" "}
                    </p>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>

      <section className="counter-one">
        <div className="container">
          <ul className="counter-one__single-list-box list-unstyled">
            <li
              className="counter-one__single-list wow fadeInLeft"
              data-wow-delay="100ms"
            >
              <div className="counter-one__single">
                <div className="counter-one__count count-box">
                  <h3 className="count-text" data-stop="35" data-speed="1500">
                    00
                  </h3>
                  <span>k</span>
                  <span>+</span>
                </div>
                <p className="counter-one__count-text">
                  Project
                  <br /> Complete
                </p>
              </div>
            </li>

            <li
              className="counter-one__single-list wow fadeInLeft"
              data-wow-delay="200ms"
            >
              <div className="counter-one__single">
                <div className="counter-one__count count-box">
                  <h3 className="count-text" data-stop="10" data-speed="1500">
                    00
                  </h3>
                  <span>k</span>
                  <span>+</span>
                </div>
                <p className="counter-one__count-text">
                  Happy <br />
                  customers
                </p>
              </div>
            </li>

            <li
              className="counter-one__single-list wow fadeInRight"
              data-wow-delay="300ms"
            >
              <div className="counter-one__single">
                <div className="counter-one__count count-box">
                  <h3 className="count-text" data-stop="25" data-speed="1500">
                    00
                  </h3>
                  <span>+</span>
                </div>
                <p className="counter-one__count-text">
                  Years <br />
                  experiences
                </p>
              </div>
            </li>

            <li
              className="counter-one__single-list wow fadeInRight"
              data-wow-delay="400ms"
            >
              <div className="counter-one__single">
                <div className="counter-one__count count-box">
                  <h3 className="count-text" data-stop="88" data-speed="1500">
                    00
                  </h3>
                </div>
                <p className="counter-one__count-text">
                  Awards <br />
                  achievement
                </p>
              </div>
            </li>
          </ul>
        </div>
      </section>

      <section className="video-one">
        <div
          className="video-one__bg"
          style={{
            backgroundImage: `url(${"/images/backgrounds/video-one-bg.jpg"})`,
          }}
        ></div>
        <div className="container">
          <div className="video-one__inner">
            <div className="video-one__video-link">
              <a
                href="https://www.youtube.com/watch?v=Get7rqXYrbQ"
                className="video-popup"
              >
                <div className="video-one__video-text">
                  <span>Play video</span>
                  <i className="ripple"></i>
                </div>
              </a>
            </div>
          </div>
        </div>
      </section>

      <section className="process-one">
        <div className="container">
          <div className="section-title text-center sec-title-animation animation-style1">
            <div className="section-title__tagline-box">
              <div className="section-title__tagline-shape"></div>
              <span className="section-title__tagline">Workflow</span>
            </div>
            <h2 className="section-title__title title-animation">
              How We Work
            </h2>
          </div>
          <div className="row">
            <div className="col-xl-4 col-lg-4">
              <div className="process-one__single">
                <div className="process-one__icon-and-count">
                  <div className="process-one__icon">
                    <Image src={"/images/icon/process-one-icon-1.png"} alt="" />
                  </div>
                  <div className="process-one__count"></div>
                  <div className="process-one__single-shape-1">
                    <Image
                      src={"/images/shapes/process-one-single-shape-1.png"}
                      alt=""
                    />
                  </div>
                </div>
                <h3 className="process-one__title">Research and Strategy</h3>
                <p className="process-one__text">
                  Conduct thorough market of the research
                  <br /> to the fast target audience behaviors.
                  <br /> Submit as many design tasks
                </p>
              </div>
            </div>

            <div className="col-xl-4 col-lg-4">
              <div className="process-one__single">
                <div className="process-one__icon-and-count">
                  <div className="process-one__icon">
                    <Image src={"/images/icon/process-one-icon-2.png"} alt="" />
                  </div>
                  <div className="process-one__count"></div>
                  <div className="process-one__single-shape-1">
                    <Image
                      src={"/images/shapes/process-one-single-shape-1.png"}
                      alt=""
                    />
                  </div>
                </div>
                <h3 className="process-one__title">Plan Customization</h3>
                <p className="process-one__text">
                  Conduct thorough market of the research
                  <br /> to the fast target audience behaviors.
                  <br /> Submit as many design tasks
                </p>
              </div>
            </div>

            <div className="col-xl-4 col-lg-4">
              <div className="process-one__single">
                <div className="process-one__icon-and-count">
                  <div className="process-one__icon">
                    <Image src={"/images/icon/process-one-icon-3.png"} alt="" />
                  </div>
                  <div className="process-one__count"></div>
                  <div className="process-one__single-shape-1">
                    <Image
                      src={"/images/shapes/process-one-single-shape-1.png"}
                      alt=""
                    />
                  </div>
                </div>
                <h3 className="process-one__title">Finished & User Testing</h3>
                <p className="process-one__text">
                  Conduct thorough market of the research
                  <br /> to the fast target audience behaviors.
                  <br /> Submit as many design tasks
                </p>
              </div>
            </div>
          </div>
        </div>
      </section>
      <section className="portfolio-three">
        <div className="container">
          <div className="portfolio-three__top">
            <div className="section-title text-left sec-title-animation animation-style1">
              <div className="section-title__tagline-box">
                <div className="section-title__tagline-shape"></div>
                <span className="section-title__tagline">Portfolio</span>
              </div>
              <h2 className="section-title__title title-animation">
                Exhibiting Outstanding Creativity
              </h2>
            </div>
            <p className="portfolio-three__text">
              Established in 1995, THE 4 LOOP has been leading force in the
              digital landscape
              for over two decades. We're a passionate
            </p>
          </div>
        </div>
        <PortfolioSlider />
      </section>

      <section className="why-choose-one">
        <div className="container">
          <div className="row">
            <div className="col-xl-6">
              <div className="why-choose-one__left">
                <div className="section-title text-left sec-title-animation animation-style2">
                  <div className="section-title__tagline-box">
                    <div className="section-title__tagline-shape"></div>
                    <span className="section-title__tagline">
                      What Sets Us Apart
                    </span>
                  </div>
                  <h2 className="section-title__title title-animation">
                    Driving Digital Success With Strategy Design
                  </h2>
                </div>
                <div className="why-choose-one__text-1">
                  We believe that the surest measure of success is when our
                  partners with us more than half It's more than just the
                  visuals.{" "}
                </div>
                <div className="why-choose-one__img-1">
                  <Image
                    src={"/images/resources/why-choose-one-img-1.jpg"}
                    alt=""
                  />
                  <div className="why-choose-one__img-shape-1"></div>
                  <div className="why-choose-one__img-shape-2"></div>
                </div>
              </div>
            </div>
            <div className="col-xl-3 col-lg-6 col-md-6">
              <div className="why-choose-one__middle">
                <div className="why-choose-one__img-2">
                  <Image
                    src={"/images/resources/why-choose-one-img-2.jpg"}
                    alt=""
                  />
                </div>
                <p className="why-choose-one__text-2">
                  Conduct thorough market research to the fast target audience
                  behaviours. Submit as many design tasks
                </p>
                <div className="why-choose-one__contact-us">
                  <a href="contact.html">
                    Contact us<span className="icon-arrow-up-right"></span>
                  </a>
                </div>
              </div>
            </div>
            <div className="col-xl-3 col-lg-6 col-md-6">
              <div className="why-choose-one__right">
                <p className="why-choose-one__text-3">
                  We believe that the surest measure of success is when our
                  partners with us more than half It's more than just the
                  visuals. We're here to support your growth.
                </p>
                <p className="why-choose-one__text-4">
                  We believe that the surest measure of success is when our
                  partners with us more than half It's more than just the
                  visuals.{" "}
                </p>
                <h3 className="why-choose-one__right-title-1">Our Mission</h3>
                <p className="why-choose-one__text-5">
                  Conduct thorough market research to the fast target audience
                  behaviours.
                </p>
                <div className="why-choose-one__right-bottom">
                  <div className="row">
                    <div className="col-xl-6 col-lg-6 col-md-6">
                      <div className="why-choose-one__mission-single">
                        <div className="why-choose-one__mission-img">
                          <Image
                            src={
                              "/images/resources/why-choose-one-mission-img-1.jpg"
                            }
                            alt=""
                          />
                        </div>
                        <div className="why-choose-one__mission-content">
                          <h4>
                            Marketing
                            <br /> Strategy
                          </h4>
                        </div>
                      </div>
                    </div>
                    <div className="col-xl-6 col-lg-6 col-md-6">
                      <div className="why-choose-one__mission-single">
                        <div className="why-choose-one__mission-img">
                          <Image
                            src={
                              "/images/resources/why-choose-one-mission-img-2.jpg"
                            }
                            alt=""
                          />
                        </div>
                        <div className="why-choose-one__mission-content">
                          <h4>
                            UX/UI
                            <br /> Solution
                          </h4>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>

      <TestimonialSection />

      <FaqsSection />

      <section className="contact-one">
        <div
          className="contact-one__bg"
          style={{
            backgroundImage: `url(${"/images/backgrounds/contact-one-bg.jpg"})`,
          }}
        ></div>
        <div className="container">
          <div className="row">
            <div className="col-xl-4"></div>
            <div className="col-xl-8">
              <div className="contact-one__right">
                <div className="section-title text-left sec-title-animation animation-style2">
                  <div className="section-title__tagline-box">
                    <div className="section-title__tagline-shape"></div>
                    <span className="section-title__tagline">CONTACT US</span>
                  </div>
                  <h2 className="section-title__title title-animation">
                    We’d Love To Hear From You
                  </h2>
                </div>
                <form
                  className="contact-form-validated contact-one__form"
                  action="assets/inc/sendemail.php"
                  method="post"
                  noValidate
                >
                  <div className="row">
                    <div className="col-xl-6 col-lg-6 col-md-6">
                      <h4 className="contact-one__input-title">
                        First Name <span>*</span>
                      </h4>
                      <div className="contact-one__input-box">
                        <input
                          type="text"
                          name="name"
                          placeholder="Enter Your First Name"
                          required
                        />
                      </div>
                    </div>
                    <div className="col-xl-6 col-lg-6 col-md-6">
                      <h4 className="contact-one__input-title">
                        Last Name <span>*</span>
                      </h4>
                      <div className="contact-one__input-box">
                        <input
                          type="text"
                          name="name"
                          placeholder="Enter Your Last Name"
                          required
                        />
                      </div>
                    </div>
                    <div className="col-xl-6 col-lg-6 col-md-6">
                      <h4 className="contact-one__input-title">
                        Email <span>*</span>
                      </h4>
                      <div className="contact-one__input-box">
                        <input
                          type="email"
                          name="email"
                          placeholder="Enter Your Email"
                          required
                        />
                      </div>
                    </div>
                    <div className="col-xl-6 col-lg-6 col-md-6">
                      <h4 className="contact-one__input-title">
                        Phone Number <span>*</span>
                      </h4>
                      <div className="contact-one__input-box">
                        <input
                          type="text"
                          name="Phone"
                          placeholder="Enter Your Phone Number"
                          required
                        />
                      </div>
                    </div>
                  </div>
                  <div className="col-xl-12">
                    <h4 className="contact-one__input-title">
                      Message <span>*</span>
                    </h4>
                    <div className="contact-one__input-box text-message-box">
                      <textarea
                        name="message"
                        placeholder="Enter Your Message"
                      ></textarea>
                    </div>
                    <div className="contact-one__btn-box">
                      <button type="submit" className="thm-btn">
                        Send A Message{" "}
                        <span className=" icon-arrow-up-right"></span>
                      </button>
                    </div>
                  </div>
                </form>
                <div className="result"></div>
                <p className="contact-one__text">
                  Didn't find what you were trying to find? Write to us at.
                </p>
                <p className="contact-one__email">
                  <a href="mailto:Info@Nexingmail.com">Info@Nexingmail.Com</a>
                </p>
              </div>
            </div>
          </div>
        </div>
      </section>
    </>
  );
}
