import Head from "next/head";
import PageHeaderBg from '../../public/images/backgrounds/page-header-bg.jpg'
import PortfolioPgOne1 from '../../public/images/project/portfolio-page-1-1.jpg'
import PortfolioPgOne2 from '../../public/images/project/portfolio-page-1-2.jpg'
import PortfolioPgOne3 from '../../public/images/project/portfolio-page-1-3.jpg'
import PortfolioPgOne4 from '../../public/images/project/portfolio-page-1-4.jpg'

import AboutSlider from "@/components/AboutSlider";

export default function Portfolio() {


    return (
        <>
            <Head>
                <title>Portfolio | Nexin</title>
                <meta name="description" content="" />
            </Head>


            <section className="page-header">
                <div className="page-header__bg" style={{ backgroundImage: `url(${PageHeaderBg.src})` }}>
                </div>
                <div className="container">
                    <div className="page-header__inner">
                        <h3>Portfolio</h3>
                        <div className="thm-breadcrumb__inner">
                            <ul className="thm-breadcrumb list-unstyled">
                                <li><a href="/">Home</a></li>
                                <li>/</li>
                                <li>Portfolio</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </section>


            <section className="portfolio-page">
                <div className="container">
                    <div className="row">

                        <div className="col-xl-6 col-lg-6 col-md-6 wow fadeInUp" data-wow-delay="100ms">
                            <div className="portfolio-page__single">
                                <div className="portfolio-page__img-box">
                                    <div className="portfolio-page__img">
                                        <img src={PortfolioPgOne1.src} alt="" />
                                    </div>
                                </div>
                                <div className="portfolio-page__content">
                                    <div className="portfolio-page__title-box">
                                        <p className="portfolio-page__sub-title">Solution</p>
                                        <h3 className="portfolio-page__title"><a href="portfolio-details.html">Creative
                                            Design</a></h3>
                                    </div>
                                    <div className="portfolio-page__arrow">
                                        <a href="portfolio-details.html"><span className="icon-arrow-up-right"></span></a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div className="col-xl-6 col-lg-6 col-md-6 wow fadeInUp" data-wow-delay="200ms">
                            <div className="portfolio-page__single portfolio-page__single-2">
                                <div className="portfolio-page__img-box">
                                    <div className="portfolio-page__img">
                                        <img src={PortfolioPgOne2.src} alt="" />
                                    </div>
                                </div>
                                <div className="portfolio-page__content">
                                    <div className="portfolio-page__title-box">
                                        <p className="portfolio-page__sub-title">Solution</p>
                                        <h3 className="portfolio-page__title"><a href="portfolio-details.html">App
                                            Developments</a></h3>
                                    </div>
                                    <div className="portfolio-page__arrow">
                                        <a href="portfolio-details.html"><span className="icon-arrow-up-right"></span></a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div className="col-xl-6 col-lg-6 col-md-6 wow fadeInUp" data-wow-delay="300ms">
                            <div className="portfolio-page__single portfolio-page__single-3">
                                <div className="portfolio-page__img-box">
                                    <div className="portfolio-page__img">
                                        <img src={PortfolioPgOne3.src} alt="" />
                                    </div>
                                </div>
                                <div className="portfolio-page__content">
                                    <div className="portfolio-page__title-box">
                                        <p className="portfolio-page__sub-title">Solution</p>
                                        <h3 className="portfolio-page__title"><a href="portfolio-details.html">Idea Generate</a>
                                        </h3>
                                    </div>
                                    <div className="portfolio-page__arrow">
                                        <a href="portfolio-details.html"><span className="icon-arrow-up-right"></span></a>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div className="col-xl-6 col-lg-6 col-md-6 wow fadeInUp" data-wow-delay="400ms">
                            <div className="portfolio-page__single portfolio-page__single-4">
                                <div className="portfolio-page__img-box">
                                    <div className="portfolio-page__img">
                                        <img src={PortfolioPgOne4.src} alt="" />
                                    </div>
                                </div>
                                <div className="portfolio-page__content">
                                    <div className="portfolio-page__title-box">
                                        <p className="portfolio-page__sub-title">Solution</p>
                                        <h3 className="portfolio-page__title"><a href="portfolio-details.html">Business
                                            Solutions</a></h3>
                                    </div>
                                    <div className="portfolio-page__arrow">
                                        <a href="portfolio-details.html"><span className="icon-arrow-up-right"></span></a>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </section>

            <section className="brand-five">
            <div className="container">
                <div className="brand-one__inner">
                    <div className="swiper-container brand-one__carousel">
                        <AboutSlider/>
                    </div>
                </div>
            </div>
        </section>

        </>
    );
}
